<?php

namespace App\Controllers;

use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\RESTful\ResourceController;
use App\Models\MahasiswaModel;

class Mahasiswa extends ResourceController
{
    protected $modelName = '\App\Models\MahasiswaModel';

    //api/mahasiswa
    public function index()
    {
        //menampilkan semua data Mahasiswa
       
        return $this->respond([
            'status'=>true,
            'data'=>$this->model->findAll(),
        ], 200);
    }
   
    public function show($id = null)
    {
        //menampilkan data mahasiswa berdasarkan id
        return $this->respond([
            'status'=>true,
            'data'=>$this->model->find($id),
        ], 200);
    }

    public function create()
    {
        //menambahkan data mahasiswa baru
        $data=[
            'nim'=> $this->request->getVar('nim'),
            'nama'=> $this->request->getVar('nama'),
            'alamat'=> $this->request->getVar('alamat'),
            'telepon'=> $this->request->getVar('telepon'),
            'email'=> $this->request->getVar('email'),
        ];
        if( $this->model->save($data)){
        return $this->respond([
            'status'=>true,
            'message'=>'Data berhasil ditambahkan',
            ], 200);
        }else{
        return $this->respond([
            'status'=>false,
            'error'=>$this->model->errors()
        ], 422);
        }
    }

  
     
    public function update($id = null)
    {
        //mengupdate data mahasiswa berdasarkan id
        if(!$this->model->find($id)){
            return $this->respond([
                'status'=>false,
                'message'=>'Data tidak ditemukan'
            ], 404);
        }
        
        $data=[
            'id' => $id,
            'nim'=> $this->request->getVar('nim'),
            'nama'=> $this->request->getVar('nama'),
            'alamat'=> $this->request->getVar('alamat'),
            'telepon'=> $this->request->getVar('telepon'),
            'email'=> $this->request->getVar('email'),
        ];
        if( $this->model->update($id,$data)){
        return $this->respond([
            'status'=>true,
            'message'=>'Data berhasil diupdate',
            ], 200);
        }else{
        return $this->respond([
            'status'=>false,
            'error'=>$this->model->errors()
        ], 422);
        }
    }

 
    public function delete($id = null)
    {
        //menghapus data mahasiswa berdasarkan id
        $this->model->delete($id);
        return $this->respond([
            'status'=>true,
            'message'=>'Data berhasil dihapus',
            ], 200);
    }
}
