<?php

namespace App\Models;

use CodeIgniter\Model;

class MahasiswaModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'yk_mahasiswa';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['nim', 'nama', 'telepon','alamat', 'email', 'created_at', 'updated_at'];

    // Dates
    protected $useTimestamps = false;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [
        'id'=> 'max_length[100]',
        'nim' => ['rules'=>'required',
                    'errors'=>[
                        'required'=>'{field} wajib diisi',
                        'is_unique'=>'{field} sudah terdaftar',
                    ],
                ],
        'nama' => ['label'=>'Nama Mahasiswa',
                    'rules'=> 'required',
                    'errors'=>[
                        'required'=>'{field} wajib diisi',
                    ],
                ],
        'telepon' => 'required|numeric|max_length[15]',
        'email' => 'required|valid_email|is_unique[yk_mahasiswa.email,id,{id}]'
    ];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];
}
